from typing import List, Optional

from axelrod.action import Action

from axelrod.player import Player

Vector = List[float]

C, D = Action.C, Action.D

class CollectiveStrategy(Player):
    """Defined in [Li2009]_. 'It always cooperates in the first move and defects
    in the second move. If the opponent also cooperates in the first move and
    defects in the second move, CS will cooperate until the opponent defects.
    Otherwise, CS will always defect.'

    Names:

    - Collective Strategy: [Li2009]_

    """

    name = "CollectiveStrategy"

    classifier = {
        "stochastic": False,
        "memory_depth": float("inf"),  # Long memory
        "long_run_time": False,
        "inspects_source": False,
        "manipulates_source": False,
        "manipulates_state": False,
    }

    def strategy(self, opponent: Player) -> Action:
        """Actual strategy definition that determines player's action."""
        turn = len(self.history)
        if turn == 0:
            return C
        if turn == 1:
            return D
        if opponent.defections > 1:
            return D
        if opponent.history[0:2] == [C, D]:
            return C
        return D